using System;

class Program
{
    static void Main(string[] args)
    {
        Console.OutputEncoding = System.Text.Encoding.UTF8;

        // Ievade: vārds un uzvārds
        Console.Write("Ievadi vārdu: ");
        string vards = Console.ReadLine();
        Console.Write("Ievadi uzvārdu: ");
        string uzvards = Console.ReadLine();

        // 1. Solis: ģenerēt datus
        int[,] dati = TabulasDati(vards, uzvards);

        // 2. Solis: izvadīt galveni un sākotnējo tabulu
        Console.WriteLine("\n--- Oriģinālā tabula ---");
        TabulaGalva(vards);
        Tabula(dati);

        // 3. Solis: transponēt un atkārtoti izvadīt
        int[,] mainīti = TabulasMaina(dati);

        Console.WriteLine("\n--- Transponētā tabula ---");
        TabulaGalva(vards);
        Tabula(mainīti);
    }

    // Zīmē horizontālu līniju ar * un -
    static void TabulasLinija(int svitras, int reizes)
    {
        for (int i = 0; i < reizes; i++)
        {
            Console.Write("*");
            Console.Write(new string('-', svitras));
        }
        Console.WriteLine("*");
    }

    // Izdrukā rindu ar datiem + max, min, sum
    static void TabulasRinda(int[] dati, int max, int min, int sum)
    {
        foreach (int skaitlis in dati)
        {
            Console.Write($"| {skaitlis,3} ");
        }
        Console.Write($"| max:{max,3} | min:{min,3} | sum:{sum,4} |");
        Console.WriteLine();
    }

    // Ģenerē 2D masīvu ar gadījuma skaitļiem (robežās no vārda garuma līdz vārds+uzvārds garumam)
    static int[,] TabulasDati(string vards, string uzvards)
    {
        int min = vards.Length;
        int max = vards.Length + uzvards.Length;
        int rindas = 3;
        int kolonnas = 4;

        int[,] masivs = new int[rindas, kolonnas];
        Random rnd = new Random();

        for (int i = 0; i < rindas; i++)
        {
            for (int j = 0; j < kolonnas; j++)
            {
                masivs[i, j] = rnd.Next(min, max + 1); // max+1 jo .Next(a,b) iekļauj a, bet ne b
            }
        }

        return masivs;
    }

    // Izdrukā tabulas galvu ar līnijām un virsrakstu
    static void TabulaGalva(string vards)
    {
        TabulasLinija(4, 7);
        Console.WriteLine($"| Tabula lietotājam: {vards,-20}         |");
        TabulasLinija(4, 7);
    }

    // Apstrādā un izdrukā 2D masīvu ar visām rindām
    static void Tabula(int[,] masivs)
    {
        for (int i = 0; i < masivs.GetLength(0); i++)
        {
            int[] rinda = new int[masivs.GetLength(1)];
            int sum = 0, max = int.MinValue, min = int.MaxValue;

            for (int j = 0; j < masivs.GetLength(1); j++)
            {
                rinda[j] = masivs[i, j];
                sum += rinda[j];
                if (rinda[j] > max) max = rinda[j];
                if (rinda[j] < min) min = rinda[j];
            }

            TabulasRinda(rinda, max, min, sum);
        }

        // Apakšējā līnija tabulai
        TabulasLinija(4, 7);
    }

    // Transponē masīvu (rindas kļūst par kolonnām un otrādi)
    static int[,] TabulasMaina(int[,] masivs)
    {
        int rindas = masivs.GetLength(0);
        int kolonnas = masivs.GetLength(1);

        int[,] transponēts = new int[kolonnas, rindas];

        for (int i = 0; i < rindas; i++)
        {
            for (int j = 0; j < kolonnas; j++)
            {
                transponēts[j, i] = masivs[i, j];
            }
        }

        return transponēts;
    }
}